function main(self)
    local claw = GetClaw()

    local triggerX1, triggerY1 = 14721, 4718
    local triggerX2, triggerY2 = 15062, 4850

    local inArea = claw.X >= triggerX1 and claw.X <= triggerX2 and
                   claw.Y >= triggerY1 and claw.Y <= triggerY2

    if not self.PictureCreated and inArea then
        self.Picture = CreateObject {
            x = 14732, y = 4847, z = 100,
            logic = "AniCycle",            -- tutaj animacja
            image = "CUSTOM_JACKSON"           -- pierwsza klatka
        }
        self.Picture:SetFrame(0)
        self.Picture:SetAnimation("GAME_CYCLE50")  -- prędkość animacji (domyślnie 50)
        self.TimerStart = GetTicks()
        self.SoundID = PlaySound("CUSTOM_TRIGGER_JACKSONO")
        self.PictureCreated = true
    end

    if self.Picture and self.TimerStart then
        local elapsed = GetTicks() - self.TimerStart

        -- przesuwanie w prawo
        self.Picture.X = self.Picture.X + 2

        if elapsed > 5000 then
            self.Picture:Destroy()
            self.Picture = nil
            if self.SoundID then
                StopSound(self.SoundID)
                self.SoundID = nil
            end
            self.TimerStart = nil
        end
    end
end